package com.jumeirah.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <pre>
 * 商家飞机表 查询结果对象
 * </pre>
 *
 * @author xxx
 * @date 2020-10-19
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "McPlainQueryVo对象")
public class McPlainQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("飞机类型ID")
    private Long ptId;

    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间（时间戳）")
    private Long createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Long updateTime;

    @ApiModelProperty("商家ID")
    private Long mcId;

    @ApiModelProperty("数量")
    private Integer amount;

    @ApiModelProperty("所在地城市ID")
    private Long cityId;
}
