package com.sien.common.service;

import io.geekidea.springbootplus.framework.common.api.ApiResult;

public interface AppSmsService {

    void deleteRegisterCode(String area, String number);
    void deleteUpdatePhoneCode(String area, String number);


    /**
     * 获取注册验证码
     */
    ApiResult<Object> registerOrLoginCode(String phoneArea, String phone);
    ApiResult<Object> updatePhoneCode() throws Exception;

    /**
     * 获取注册验证码
     */
    ApiResult LoginType(String area, String number);

    /**
     * 校验注册验证码
     *
     * @param area
     * @param number
     * @param code
     * @return
     */
    boolean equalsRegisterCode(String area, String number, String code);
    boolean equalsUpdatePhoneCode(String area, String number, String code);

    /**
     * 校验验登陆证码
     *
     * @param area
     * @param number
     * @param code
     * @return
     */
    boolean equalsLoginCode(String area, String number, String code);

}
