package com.jumeirah.api.app.controller;

import com.jumeirah.common.param.CharterIntroductionPageParam;
import com.jumeirah.common.service.CharterIntroductionService;
import com.jumeirah.common.vo.CharterIntroductionQueryForAppVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 包机介绍 控制器
 *
 * @author giao
 * @since 2020-10-14
 */
@Slf4j
@RestController
@RequestMapping("/app/charterIntroduction")
@Api(value = "包机介绍API", tags = {"包机介绍"})
public class CharterIntroductionForAppController extends BaseController {

    @Autowired
    private CharterIntroductionService charterIntroductionService;

//    /**
//     * 添加包机介绍
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加包机介绍", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加包机介绍")
//    public ApiResult<Boolean> addCharterIntroduction(@Validated(Add.class) @RequestBody CharterIntroduction charterIntroduction) throws Exception {
//        boolean flag = charterIntroductionService.saveCharterIntroduction(charterIntroduction);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改包机介绍
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改包机介绍", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改包机介绍")
//    public ApiResult<Boolean> updateCharterIntroduction(@Validated(Update.class) @RequestBody CharterIntroduction charterIntroduction) throws Exception {
//        boolean flag = charterIntroductionService.updateCharterIntroduction(charterIntroduction);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除包机介绍
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除包机介绍", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除包机介绍")
//    public ApiResult<Boolean> deleteCharterIntroduction(@PathVariable("id") Long id) throws Exception {
//        boolean flag = charterIntroductionService.deleteCharterIntroduction(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取包机介绍详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "包机介绍详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "包机介绍详情")
//    public ApiResult<CharterIntroductionQueryVo> getCharterIntroduction(@PathVariable("id") Long id) throws Exception {
//        CharterIntroductionQueryVo charterIntroductionQueryVo = charterIntroductionService.getCharterIntroductionById(id);
//        return ApiResult.ok(charterIntroductionQueryVo);
//    }

//    /**
//     * 包机介绍分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "包机介绍分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "包机介绍分页列表")
//    public ApiResult<Paging<CharterIntroductionQueryVo>> getCharterIntroductionPageList(@Validated @RequestBody CharterIntroductionPageParam charterIntroductionPageParam) throws Exception {
//        Paging<CharterIntroductionQueryVo> paging = charterIntroductionService.getCharterIntroductionPageList(charterIntroductionPageParam);
//        return ApiResult.ok(paging);
//    }

    /**
     * 包机介绍分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "包机介绍分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "包机介绍分页列表")
    public ApiResult<Paging<CharterIntroductionQueryForAppVo>> getCharterIntroductionPageList(@Validated @RequestBody CharterIntroductionPageParam charterIntroductionPageParam) throws Exception {
        Paging<CharterIntroductionQueryForAppVo> paging = charterIntroductionService.getCharterIntroductionForAppPageList(charterIntroductionPageParam);
        return ApiResult.ok(paging);
    }


}

