package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.MerchantRolePermission;
import com.jumeirah.common.param.MerchantRolePermissionPageParam;
import com.jumeirah.common.vo.MerchantRolePermissionQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.Set;

/**
 * 商家角色权限关系 Mapper 接口
 *
 * @author wei
 * @since 2020-09-28
 */
@Repository
public interface MerchantRolePermissionMapper extends BaseMapper<MerchantRolePermission> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    MerchantRolePermissionQueryVo getMerchantRolePermissionById(Serializable id);


    /**
     * 根据角色id获取可用的权限编码
     *
     * @param roleId
     * @return
     */
    Set<String> getPermissionCodesByRoleId(@Param("roleId") Long roleId);

    /**
     * 获取分页对象
     *
     * @param page
     * @param merchantRolePermissionPageParam
     * @return
     */
    IPage<MerchantRolePermissionQueryVo> getMerchantRolePermissionPageList(@Param("page") Page page, @Param("param") MerchantRolePermissionPageParam merchantRolePermissionPageParam);

}
