package com.jumeirah.common.service;

import com.jumeirah.common.entity.VersionControl;
import com.jumeirah.common.param.VersionControlPageParam;
import com.jumeirah.common.param.VersionControlQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * App版本控制 服务类
 *
 * @author giao
 * @since 2020-10-26
 */
public interface VersionControlService extends BaseService<VersionControl> {

    /**
     * 保存
     *
     * @param versionControl
     * @return
     * @throws Exception
     */
    boolean saveVersionControl(VersionControl versionControl) throws Exception;

    /**
     * 修改
     *
     * @param versionControl
     * @return
     * @throws Exception
     */
    boolean updateVersionControl(VersionControl versionControl) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteVersionControl(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    VersionControlQueryVo getVersionControlById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param versionControlPageParam
     * @return
     * @throws Exception
     */
    Paging<VersionControlQueryVo> getVersionControlPageList(VersionControlPageParam versionControlPageParam) throws Exception;

}
