package com.sien.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sien.common.entity.DonationRecord;
import com.sien.common.param.DonationRecordPageParam;
import com.sien.common.vo.DonationRankAndTotal;
import com.sien.common.vo.DonationRecordQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 捐款记录 Mapper 接口
 *
 * @author hewei
 * @since 2021-02-25
 */
@Repository
public interface DonationRecordMapper extends BaseMapper<DonationRecord> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    DonationRecordQueryVo getDonationRecordById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param donationRecordPageParam
     * @return
     */
    IPage<DonationRecordQueryVo> getDonationRecordPageList(@Param("page") Page page, @Param("param") DonationRecordPageParam donationRecordPageParam);


    /**
     * 查询捐款排名
     *
     * @param userId
     * @return
     */
    DonationRankAndTotal getDonationRankAndTotal(@Param("userId") Long userId);
}
