package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.MerchantRolePermission;
import com.jumeirah.common.mapper.MerchantRolePermissionMapper;
import com.jumeirah.common.param.MerchantRolePermissionPageParam;
import com.jumeirah.common.service.MerchantRolePermissionService;
import com.jumeirah.common.vo.MerchantRolePermissionQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Set;

/**
 * 商家角色权限关系 服务实现类
 *
 * @author wei
 * @since 2020-09-28
 */
@Slf4j
@Service
public class MerchantRolePermissionServiceImpl extends BaseServiceImpl<MerchantRolePermissionMapper, MerchantRolePermission> implements MerchantRolePermissionService {

    @Autowired
    private MerchantRolePermissionMapper merchantRolePermissionMapper;

    @Override
    public Set<String> getPermissionCodesByRoleId(Long roleId) throws Exception {
        return merchantRolePermissionMapper.getPermissionCodesByRoleId(roleId);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveMerchantRolePermission(MerchantRolePermission merchantRolePermission) throws Exception {
        return super.save(merchantRolePermission);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateMerchantRolePermission(MerchantRolePermission merchantRolePermission) throws Exception {
        return super.updateById(merchantRolePermission);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteMerchantRolePermission(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public MerchantRolePermissionQueryVo getMerchantRolePermissionById(Long id) throws Exception {
        return merchantRolePermissionMapper.getMerchantRolePermissionById(id);
    }

    @Override
    public Paging<MerchantRolePermissionQueryVo> getMerchantRolePermissionPageList(MerchantRolePermissionPageParam merchantRolePermissionPageParam) throws Exception {
        Page<MerchantRolePermissionQueryVo> page = new PageInfo<>(merchantRolePermissionPageParam, OrderItem.desc(getLambdaColumn(MerchantRolePermission::getCreateTime)));
        IPage<MerchantRolePermissionQueryVo> iPage = merchantRolePermissionMapper.getMerchantRolePermissionPageList(page, merchantRolePermissionPageParam);
        return new Paging<MerchantRolePermissionQueryVo>(iPage);
    }

}
