package com.ym.im.mq;

import com.ym.im.config.RabbitConfig;
import com.ym.im.entity.StaffSocketInfo;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * @Date:2019-05-30
 */
@Component
public class Queue {

    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Autowired
    private RabbitConfig rabbitConfig;

    /**
     * 客服离线 队列
     *
     * @param msgBody
     */
    public void staffOfflineQueue(StaffSocketInfo staffSocketInfo) {
        //客服下线后 转发用户到其他客服
        rabbitTemplate.convertAndSend(rabbitConfig.getExchangeName(), rabbitConfig.getStaffOfflineQueueName(), staffSocketInfo, message -> {
            message.getMessageProperties().setDelay((60 * 1000));   // 毫秒为单位，指定此消息的延时时长
            return message;
        });
    }


}