package com.jumeirah.api.merchant.entity.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * 商家飞机表
 *
 * @author xxx
 * @since 2020-10-19
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "McPlain对象")
public class McPlainAddParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键ID")
    private Long id;

    @NotNull(message = "飞机类型ID不能为空")
    @ApiModelProperty("飞机类型ID")
    private Long ptId;

    @NotNull(message = "数量不能为空")
    @ApiModelProperty("数量")
    private Integer amount;

    @NotNull(message = "所在地城市ID不能为空")
    @ApiModelProperty("所在地城市ID")
    private Long cityId;

}
