package com.jumeirah.api.merchant.controller.order;

import com.jumeirah.api.merchant.entity.param.StrokeCancelParam;
import com.jumeirah.api.merchant.entity.param.StrokeConfirmPaymentParam;
import com.jumeirah.api.merchant.entity.param.StrokeDiscountCheckParam;
import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.enums.StatePaymentStatusEnum;
import com.jumeirah.common.enums.StrokeStatusEnum;
import com.jumeirah.common.factory.PushFactory;
import com.jumeirah.common.param.McStrokePageParam;
import com.jumeirah.common.param.StrokeCompleteParam;
import com.jumeirah.common.param.StrokeQuotedPriceParam;
import com.jumeirah.common.service.AppUserService;
import com.jumeirah.common.service.StrokeService;
import com.jumeirah.common.vo.McStrokeQueryVo;
import com.jumeirah.common.vo.StrokeDetailVo;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.sql.Timestamp;

/**
 * 行程表 控制器
 *
 * @author wei
 * @since 2020-09-29
 */
@Slf4j
@RestController
@RequestMapping("/merchant/stroke")
@Api(value = "行程API", tags = {"行程"})
public class McStrokeController extends BaseController {

    @Autowired
    private StrokeService strokeService;
    @Autowired
    private PushFactory pushFactory;
    @Autowired
    private AppUserService appUserService;

    /**
     * 完成行程接口
     */
    @PostMapping("/complete")
    @OperationLog(name = "完成行程接口", type = OperationLogType.UPDATE)
    @ApiOperation(value = "完成行程接口", response = ApiResult.class)
    @RequiresPermissions("merchant:order:edit")
    public ApiResult<Boolean> completeStroke(@Validated @RequestBody StrokeCompleteParam strokeCompleteParam) throws Exception {
        ApiResult<Boolean> result = strokeService.completeStroke(strokeCompleteParam);
        if (result.getCode() == ApiCode.SUCCESS.getCode()) {
            sendAppMsg(strokeCompleteParam.getId(), "3", "您的订单已完成");
        }
        return result;
    }

    /**
     * 发送推送信息给APP端
     *
     * @param id
     * @param pushType
     * @param title
     * @throws Exception
     */
    private void sendAppMsg(Long id, String pushType, String title) throws Exception {
        StrokeDetailVo newStroke = strokeService.getStrokeById(id);
        AppUser appUser = appUserService.getById(newStroke.getUserId());
        pushFactory.getService(appUser.getDeviceType()).unicast(appUser.getDeviceToken(), pushType, title);
    }

    /**
     * 行程表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "行程分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "行程分页列表")
    @RequiresPermissions("merchant:order:view")
    public ApiResult<Paging<McStrokeQueryVo>> getMyStrokePageList(@Validated @RequestBody McStrokePageParam mcStrokePageParam, @RequestHeader(required = false) String language) throws Exception {
        Paging<McStrokeQueryVo> paging = strokeService.getMcStrokePageList(mcStrokePageParam, language);
        return ApiResult.ok(paging);
    }

    /**
     * 行程报价接口
     */
    @PostMapping("/update/quotedPrice")
    @OperationLog(name = "行程报价接口", type = OperationLogType.UPDATE)
    @ApiOperation(value = "行程报价接口", response = ApiResult.class)
    @RequiresPermissions("merchant:order:edit")
    public ApiResult<Boolean> updateStroke(@Validated @RequestBody StrokeQuotedPriceParam strokeQuotedPriceParam) throws Exception {
        ApiResult<Boolean> result = strokeService.quotedPrice(strokeQuotedPriceParam);
        if (result.getCode() == ApiCode.SUCCESS.getCode()) {
            sendAppMsg(strokeQuotedPriceParam.getId(), "2", "您的订单已报价");
        }
        return result;
    }

    /**
     * 优惠调机审核接口
     */
    @PostMapping("/discount/check")
    @OperationLog(name = "优惠调机审核接口", type = OperationLogType.UPDATE)
    @ApiOperation(value = "优惠调机审核接口", response = ApiResult.class)
    @RequiresPermissions("merchant:order:edit")
    public ApiResult<Boolean> checkStrokeDiscount(@Validated @RequestBody StrokeDiscountCheckParam strokeDiscountCheckParam) throws Exception {
        Stroke stroke = new Stroke();
        stroke.setId(strokeDiscountCheckParam.getId())
                .setUpdateTime(new Timestamp(System.currentTimeMillis()))
                .setAuditStatus(strokeDiscountCheckParam.getAuditStatus());
        boolean flag = strokeService.updateStroke(stroke);
        return ApiResult.result(flag);
    }

    /**
     * 行程订单确认付款接口
     */
    @PostMapping("/confirmPayment")
    @OperationLog(name = "行程订单确认付款接口", type = OperationLogType.UPDATE)
    @ApiOperation(value = "行程订单确认付款接口", response = ApiResult.class)
    @RequiresPermissions("merchant:order:edit")
    public ApiResult<Boolean> confirmPaymentStroke(@Validated @RequestBody StrokeConfirmPaymentParam strokeConfirmPaymentParam) throws Exception {
        Stroke stroke = new Stroke();
        stroke.setId(strokeConfirmPaymentParam.getId())
                .setStatus(StrokeStatusEnum.PROCESSING.getCode())
                .setUpdateTime(new Timestamp(System.currentTimeMillis()))
                .setPaymentStatus(StatePaymentStatusEnum.PAID.getCode());
        boolean flag = strokeService.updateStroke(stroke);
        return ApiResult.result(flag);
    }

    /**
     * 取消(驳回)订单接口
     */
    @PostMapping("/cancel")
    @OperationLog(name = "取消(驳回)订单接口", type = OperationLogType.UPDATE)
    @ApiOperation(value = "取消(驳回)订单接口", response = ApiResult.class)
    @RequiresPermissions("merchant:order:edit")
    public ApiResult<Boolean> cancel(@Validated @RequestBody StrokeCancelParam strokeCancelParam) throws Exception {

        boolean flag = strokeService.cancel(strokeCancelParam.getId());
        return ApiResult.result(flag);
    }


    /* *//**
     * 修改行程表
     *//*
    @PostMapping("/update")
    @OperationLog(name = "修改行程表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改行程表", response = ApiResult.class)
    public ApiResult<Boolean> updateStroke(@Validated(Update.class) @RequestBody Stroke stroke) throws Exception {
        boolean flag = strokeService.updateStroke(stroke);
        return ApiResult.result(flag);
    }

    *//**
     * 删除行程表
     *//*
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除行程表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除行程表", response = ApiResult.class)
    public ApiResult<Boolean> deleteStroke(@PathVariable("id") Long id) throws Exception {
        boolean flag = strokeService.deleteStroke(id);
        return ApiResult.result(flag);
    }

    *//**
     * 获取行程表详情
     *//*
    @GetMapping("/info/{id}")
    @OperationLog(name = "行程表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "行程表详情", response = StrokeDetailVo.class)
    public ApiResult<StrokeDetailVo> getStroke(@PathVariable("id") Long id) throws Exception {
        StrokeDetailVo strokeQueryVo = strokeService.getStrokeById(id);
        return ApiResult.ok(strokeQueryVo);
    }*/

}

