package com.sien.common.service.impl;

import com.sien.common.entity.VipRecord;
import com.sien.common.mapper.VipRecordMapper;
import com.sien.common.service.VipRecordService;
    import com.sien.common.param.VipRecordPageParam;
    import com.sien.common.param.VipRecordQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
    import com.baomidou.mybatisplus.core.metadata.IPage;
    import com.baomidou.mybatisplus.core.metadata.OrderItem;
    import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
    import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 捐款记录 服务实现类
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@Service
public class VipRecordServiceImpl extends BaseServiceImpl<VipRecordMapper, VipRecord> implements VipRecordService {

@Autowired
private VipRecordMapper vipRecordMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveVipRecord(VipRecord vipRecord)throws Exception{
        return super.save(vipRecord);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateVipRecord(VipRecord vipRecord)throws Exception{
        return super.updateById(vipRecord);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteVipRecord(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public VipRecordQueryVo getVipRecordById(Long id)throws Exception{
            return vipRecordMapper.getVipRecordById(id);
            }

@Override
public Paging<VipRecordQueryVo> getVipRecordPageList(VipRecordPageParam vipRecordPageParam)throws Exception{
        Page<VipRecordQueryVo> page=new PageInfo<>(vipRecordPageParam,OrderItem.desc(getLambdaColumn(VipRecord::getCreateTime)));
            IPage<VipRecordQueryVo> iPage= vipRecordMapper.getVipRecordPageList(page, vipRecordPageParam);
        return new Paging<VipRecordQueryVo>(iPage);
        }

        }
