package com.sien.common.service.impl;

import com.sien.common.entity.DonationRecord;
import com.sien.common.mapper.DonationRecordMapper;
import com.sien.common.service.DonationRecordService;
    import com.sien.common.param.DonationRecordPageParam;
    import com.sien.common.param.DonationRecordQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
    import com.baomidou.mybatisplus.core.metadata.IPage;
    import com.baomidou.mybatisplus.core.metadata.OrderItem;
    import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
    import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 捐款记录 服务实现类
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@Service
public class DonationRecordServiceImpl extends BaseServiceImpl<DonationRecordMapper, DonationRecord> implements DonationRecordService {

@Autowired
private DonationRecordMapper donationRecordMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveDonationRecord(DonationRecord donationRecord)throws Exception{
        return super.save(donationRecord);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateDonationRecord(DonationRecord donationRecord)throws Exception{
        return super.updateById(donationRecord);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteDonationRecord(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public DonationRecordQueryVo getDonationRecordById(Long id)throws Exception{
            return donationRecordMapper.getDonationRecordById(id);
            }

@Override
public Paging<DonationRecordQueryVo> getDonationRecordPageList(DonationRecordPageParam donationRecordPageParam)throws Exception{
        Page<DonationRecordQueryVo> page=new PageInfo<>(donationRecordPageParam,OrderItem.desc(getLambdaColumn(DonationRecord::getCreateTime)));
            IPage<DonationRecordQueryVo> iPage= donationRecordMapper.getDonationRecordPageList(page, donationRecordPageParam);
        return new Paging<DonationRecordQueryVo>(iPage);
        }

        }
