package com.sien.common.service.impl;

import com.sien.common.entity.DonationAgent;
import com.sien.common.mapper.DonationAgentMapper;
import com.sien.common.service.DonationAgentService;
    import com.sien.common.param.DonationAgentPageParam;
    import com.sien.common.param.DonationAgentQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
    import com.baomidou.mybatisplus.core.metadata.IPage;
    import com.baomidou.mybatisplus.core.metadata.OrderItem;
    import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
    import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 替他人捐款记录表 服务实现类
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@Service
public class DonationAgentServiceImpl extends BaseServiceImpl<DonationAgentMapper, DonationAgent> implements DonationAgentService {

@Autowired
private DonationAgentMapper donationAgentMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveDonationAgent(DonationAgent donationAgent)throws Exception{
        return super.save(donationAgent);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateDonationAgent(DonationAgent donationAgent)throws Exception{
        return super.updateById(donationAgent);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteDonationAgent(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public DonationAgentQueryVo getDonationAgentById(Long id)throws Exception{
            return donationAgentMapper.getDonationAgentById(id);
            }

@Override
public Paging<DonationAgentQueryVo> getDonationAgentPageList(DonationAgentPageParam donationAgentPageParam)throws Exception{
        Page<DonationAgentQueryVo> page=new PageInfo<>(donationAgentPageParam,OrderItem.desc(getLambdaColumn(DonationAgent::getCreateTime)));
            IPage<DonationAgentQueryVo> iPage= donationAgentMapper.getDonationAgentPageList(page, donationAgentPageParam);
        return new Paging<DonationAgentQueryVo>(iPage);
        }

        }
