package com.sien.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.sien.common.entity.UserActiveRecord;
import com.sien.common.param.UserActiveRecordPageParam;
import com.sien.common.param.UserActiveRecordQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * app用户活跃记录表 Mapper 接口
 *
 * @author giao
 * @since 2020-10-21
 */
@Repository
public interface UserActiveRecordMapper extends BaseMapper<UserActiveRecord> {

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             */
        UserActiveRecordQueryVo getUserActiveRecordById(Serializable id);

            /**
             * 获取分页对象
             *
             * @param page
             * @param userActiveRecordPageParam
             * @return
             */
            IPage<UserActiveRecordQueryVo> getUserActiveRecordPageList(@Param("page") Page page,@Param("param") UserActiveRecordPageParam userActiveRecordPageParam);

        }
