package com.sien.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sien.common.entity.SysNotice;
import com.sien.common.param.SysNoticePageParam;
import com.sien.common.param.SysNoticeQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 系统通知表 Mapper 接口
 *
 * @author xxx
 * @since 2020-11-06
 */
@Repository
public interface SysNoticeMapper extends BaseMapper<SysNotice> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    SysNoticeQueryVo getSysNoticeById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param sysNoticePageParam
     * @return
     */
    IPage<SysNoticeQueryVo> getSysNoticePageList(@Param("page") Page page, @Param("param") SysNoticePageParam sysNoticePageParam);

}
