package com.sien.common.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

import io.geekidea.springbootplus.framework.core.validator.groups.Update;

/**
 * 商家角色权限关系
 *
 * @author wei
 * @since 2020-09-28
 */
@Data
@Accessors(chain = true)
    @EqualsAndHashCode(callSuper = true)
@ApiModel(value = "MerchantRolePermission对象")
public class MerchantRolePermission extends BaseEntity {
private static final long serialVersionUID=1L;

            @NotNull(message = "id不能为空", groups = {Update.class})
        @ApiModelProperty("主键")
                @TableId(value = "id", type = IdType.AUTO)
                private Long id;

            @NotNull(message = "角色id不能为空")
        @ApiModelProperty("角色id")
        private Long roleId;

            @NotNull(message = "权限id不能为空")
        @ApiModelProperty("权限id")
        private Long permissionId;

            @ApiModelProperty("状态，0：禁用，1：启用")
        private Integer state;

            @ApiModelProperty("备注")
        private String remark;

            @ApiModelProperty("版本")
        @Version
    private Integer version;

            @ApiModelProperty("创建时间")
        private Date createTime;

            @ApiModelProperty("修改时间")
        private Date updateTime;

}
