package com.sien.common.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.geekidea.springbootplus.framework.core.validator.groups.Update;

/**
 * 商家角色
 *
 * @author wei
 * @since 2020-09-28
 */
@Data
@Accessors(chain = true)
    @EqualsAndHashCode(callSuper = true)
@ApiModel(value = "MerchantRole对象")
public class MerchantRole extends BaseEntity {
private static final long serialVersionUID=1L;

            @NotNull(message = "id不能为空", groups = {Update.class})
        @ApiModelProperty("主键")
                @TableId(value = "id", type = IdType.AUTO)
                private Long id;

            @NotBlank(message = "角色名称不能为空")
        @ApiModelProperty("角色名称")
        private String name;

            @ApiModelProperty("角色唯一编码")
        private String code;

            @ApiModelProperty("角色类型")
        private Integer type;

            @ApiModelProperty("角色状态，0：禁用，1：启用")
        private Integer state;

            @ApiModelProperty("备注")
        private String remark;

            @ApiModelProperty("版本")
        @Version
    private Integer version;

            @ApiModelProperty("创建时间")
        private Date createTime;

            @ApiModelProperty("修改时间")
        private Date updateTime;

}
