package com.sien.api.app.entity.bo;

import com.sien.common.entity.PlainType;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 飞机型号表
 *
 * @author wei
 * @since 2020-10-09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "分组获取飞机类型对象")
public class PlainTypeBo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系列类型，0-尊享系列 , 1-奢享系列 ,2-普通系列")
    private Integer type;

    @ApiModelProperty("系列名称")
    private List<PlainType> plainTypeList;

}
