package com.sien.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * <pre>
 * 行程表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-29
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "StrokeQueryVo对象")
public class StrokeQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("商家ID")
    private Long merchantId;

    @ApiModelProperty("出发城市名称")
    private String cityOutsetName;

    @ApiModelProperty("到达城市名称")
    private String cityArriveName;

    @ApiModelProperty("飞机型号名称")
    private String plainTypeName;

    @ApiModelProperty("出发时间")
    private Timestamp outsetTime;

    @ApiModelProperty("返程时间")
    private Timestamp returnTime;

    @ApiModelProperty("行程类型，0-单程，1-往返行程，2-货运，3-医疗")
    private Integer type;

    @ApiModelProperty("付款状态，0-未付款，1-用户已付款,待审核，2-用户已付款,审核通过，3-退款中，99-已退款")
    private Integer status;

    @ApiModelProperty("价格")
    private BigDecimal money;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("商家名称")
    private String merchantName;

    @NotBlank(message = "出发机场名称不能为空")
    @ApiModelProperty("出发机场名称")
    private String outsetAirportName;

    @NotBlank(message = "到达机场名称不能为空")
    @ApiModelProperty("到达机场名称")
    private String arriveAirportName;

    @NotNull(message = "付款状态不能为空")
    @ApiModelProperty("付款状态，0-未付款，1-付款中，2-已付款，3-退款中，99-已退款")
    private Integer paymentStatus;

    @NotNull(message = "审核状态不能为空")
    @ApiModelProperty("审核状态,0审核中,1审核通过,2审核未通过")
    private Integer auditStatus;

    @NotBlank(message = "商家开户银行不能为空")
    @ApiModelProperty("商家开户银行")
    private String rechargeBank;

    @NotBlank(message = "商家开户名称不能为空")
    @ApiModelProperty("商家开户名称")
    private String rechargeName;

    @NotBlank(message = "商家银行卡号")
    @ApiModelProperty("商家银行卡号")
    private String rechargeBankNumber;

    @NotBlank(message = "是否是优惠调机不能为空")
    @ApiModelProperty("是否是优惠调机，0-否，1-是")
    private Boolean isDiscount;
}
