package com.sien.common.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sien.common.service.AppSmsService;
import com.sien.common.service.AppUserApiService;
import com.sien.common.param.app.AppSmsRegisterParam;
import com.sien.common.param.app.AppUserInfoParam;
import com.sien.common.service.AppUserService;
import com.sien.common.vo.app.LoginAppUserTokenVo;
import com.sien.common.entity.AppUser;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

@Service
public class AppUserApiServiceImpl implements AppUserApiService {

    @Autowired
    private AppSmsService appSmsService;
    @Autowired
    private AppUserService appUserService;


    @Override
    public ApiResult<Boolean> updatePhone(String phoneArea, String phone, String code) throws Exception {
//        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
//
//        AppUserQueryVo appUserById = appUserService.getAppUserById(jwtToken.getUserId());
//
//        // 校验验证码
//        boolean equalsRegisterCode = appSmsService.equalsUpdatePhoneCode(appUserById.getPhoneArea(), appUserById.getPhone(), code);
//        if (!equalsRegisterCode) {
//            return ApiResult.fail(ApiCode.SMS_CODE_ERROR);
//        }
//        // 删除已使用的验证码
//        appSmsService.deleteUpdatePhoneCode(appUserById.getPhoneArea(), appUserById.getPhone());
//
//        // 判断手机号是否已经注册
//        AppUser one = appUserService.getOne(new QueryWrapper<AppUser>().lambda()
//                .eq(AppUser::getPhoneArea, phoneArea)
//                .eq(AppUser::getPhone, phone));
//        if (one != null) {
//            return ApiResult.fail(ApiCode.BUSINESS_EXCEPTION);
//        }
//
//
//        AppUser appUser = new AppUser();
//        appUser.setPhoneArea(phoneArea);
//        appUser.setPhone(phone);
//        appUser.setId(jwtToken.getUserId());
//
//        boolean b = appUserService.updateById(appUser);
//        if (b) {
//            return ApiResult.ok();
//        }
        return ApiResult.fail();
    }

    @Override
    public AppUser getUserInfo(Long userId) {
        return appUserService.getOne(new QueryWrapper<AppUser>().lambda().eq(AppUser::getId, userId));
    }

    @Override
    public ApiResult<List<AppUser>> getAppUserList(Set<Long> uids) {
        return ApiResult.ok(appUserService.list(new QueryWrapper<AppUser>().lambda().in(AppUser::getId, uids)));
    }

    @Override
    public ApiResult<LoginAppUserTokenVo> register(AppSmsRegisterParam loginParam, String language) throws Exception {
        // 校验验证码
        boolean equalsRegisterCode = appSmsService.equalsRegisterCode(loginParam.getPhoneArea(), loginParam.getPhone(), loginParam.getSmsCode());
        if (!equalsRegisterCode) {
            return ApiResult.fail(ApiCode.SMS_CODE_ERROR, new LoginAppUserTokenVo());
        }
        // 删除已使用的验证码
        appSmsService.deleteRegisterCode(loginParam.getPhoneArea(), loginParam.getPhone());
        // 判断是否已经注册
        if (appUserService.hasUserByPhoneNumer(loginParam.getPhoneArea(), loginParam.getPhone())) {
            // 如果已经注册直接走登陆的代码
            return appUserService.login(loginParam, language, true);
        }

        // 没注册则先保存到数据库
        AppUser appUser = new AppUser();
        appUser.setPhoneArea(loginParam.getPhoneArea());
        appUser.setPhone(loginParam.getPhone());
        appUser.setWechatOpenId(loginParam.getOpenid());
        boolean isDbOk = appUserService.saveAppUser(appUser);
        if (!isDbOk) {
            return ApiResult.fail(ApiCode.SPRING_BOOT_PLUS_EXCEPTION, new LoginAppUserTokenVo());
        }

        // 走登陆的代码
        return appUserService.login(loginParam, language, false);
    }

//    @Override
//    public ApiResult<LoginAppUserTokenVo> login(AppSmsRegisterParam loginParam, String language) throws Exception {
//        return null;
//    }

    @Override
    public boolean updateAppUser(AppUserInfoParam appUserInfoParam) throws Exception {

        AppUser appUser = new AppUser();
        BeanUtils.copyProperties(appUserInfoParam, appUser);

        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();

        appUser.setId(jwtToken.getUserId());

        return appUserService.updateAppUser(appUser);
    }

}
