package com.sien.common.param.app;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * APP用户
 *
 * @author wei
 * @since 2020-09-23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AppUserInfoParam对象")
public class AppUserInfoParam extends BaseEntity {

    @ApiModelProperty("姓名")
    private String nickname;

    @ApiModelProperty("性别，0：女，1：男，默认1")
    private Integer gender;

    @ApiModelProperty("证件号码")
    private String idcard;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("出生日期")
    private String dateOfBirth;

    @ApiModelProperty("文化程度")
    private String educationBackground;

    @ApiModelProperty("邮件")
    private String email;

    @ApiModelProperty("省市区")
    private String location;

    @ApiModelProperty("详细地址")
    private String locationDetail;

    @ApiModelProperty("职业")
    private String profession;

    @ApiModelProperty("工作单位")
    private String company;

    @ApiModelProperty("紧急电话")
    private String emergencyPhone;

    @ApiModelProperty("头像")
    private String head;

}
