package com.sien.common.controller;

import com.sien.common.entity.DonationAgent;
import com.sien.common.param.DonationAgentPageParam;
import com.sien.common.service.DonationAgentService;
import com.sien.common.vo.DonationAgentQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 替他人捐款记录表 控制器
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@RestController
@RequestMapping("/donationAgent")
@Api(value = "替他人捐款记录表API", tags = {"替他人捐款记录表"})
public class DonationAgentController extends BaseController {

    @Autowired
    private DonationAgentService donationAgentService;

    /**
     * 添加替他人捐款记录表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加替他人捐款记录表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加替他人捐款记录表")
    public ApiResult<Boolean> addDonationAgent(@Validated(Add.class) @RequestBody DonationAgent donationAgent) throws Exception {
        boolean flag = donationAgentService.saveDonationAgent(donationAgent);
        return ApiResult.result(flag);
            }

    /**
     * 修改替他人捐款记录表
     */
    @PostMapping("/update")
        @OperationLog(name = "修改替他人捐款记录表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改替他人捐款记录表")
    public ApiResult<Boolean> updateDonationAgent(@Validated(Update.class) @RequestBody DonationAgent donationAgent)throws Exception{
            boolean flag= donationAgentService.updateDonationAgent(donationAgent);
            return ApiResult.result(flag);
            }

    /**
     * 删除替他人捐款记录表
     */
    @PostMapping("/delete/{id}")
        @OperationLog(name = "删除替他人捐款记录表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除替他人捐款记录表")
    public ApiResult<Boolean> deleteDonationAgent(@PathVariable("id") Long id)throws Exception{
            boolean flag= donationAgentService.deleteDonationAgent(id);
            return ApiResult.result(flag);
            }

    /**
     * 获取替他人捐款记录表详情
     */
    @GetMapping("/info/{id}")
        @OperationLog(name = "替他人捐款记录表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "替他人捐款记录表详情")
    public ApiResult<DonationAgentQueryVo> getDonationAgent(@PathVariable("id") Long id)throws Exception{
            DonationAgentQueryVo donationAgentQueryVo = donationAgentService.getDonationAgentById(id);
            return ApiResult.ok(donationAgentQueryVo);
            }

    /**
     * 替他人捐款记录表分页列表
     */
    @PostMapping("/getPageList")
        @OperationLog(name = "替他人捐款记录表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "替他人捐款记录表分页列表")
    public ApiResult<Paging<DonationAgentQueryVo>>getDonationAgentPageList(@Validated @RequestBody DonationAgentPageParam donationAgentPageParam)throws Exception{
            Paging<DonationAgentQueryVo> paging = donationAgentService.getDonationAgentPageList(donationAgentPageParam);
            return ApiResult.ok(paging);
            }

}

