package com.sien.common.controller;

import com.sien.common.service.AppSmsService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * APP用户 控制器
 *
 * @author wei
 * @since 2020-09-23
 */
@Slf4j
@RestController
//@Module("api-app")
@Api(value = "短信验证码", tags = {"APP短信验证码相关"})
@RequestMapping("/sms")
public class AppSmsController extends BaseController {

    @Autowired
    private AppSmsService appSmsService;

    /**
     * 获取注册验证码
     */
    @GetMapping("/registerOrLoginCode")
    @OperationLog(name = "获取注册或登陆的验证码", type = OperationLogType.INFO)
    @ApiOperation(value = "获取注册或登陆的验证码", response = Object.class, notes = "本地环境默认666666")
    public ApiResult<Object> registerOrLoginCode(@RequestParam String phoneArea, @RequestParam String phone) throws Exception {

        return appSmsService.registerOrLoginCode(phoneArea, phone);
    }

//    /**
//     * 获取修改手机号的验证码
//     */
//    @GetMapping("/updatePhoneCode")
//    @OperationLog(name = "获取修改手机号的验证码", type = OperationLogType.INFO)
//    @ApiOperation(value = "获取修改手机号的验证码", response = Object.class, notes = "本地环境默认666666")
//    public ApiResult<Object> updatePhoneCode() throws Exception {
//
//        return appSmsService.updatePhoneCode();
//    }

}

