package com.jumeirah.api.app.entity.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 行程表
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "添加单程行程入参对象")
public class StrokeAddOneWayVo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "出发城市id不能为空")
    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @NotBlank(message = "出发城市名称不能为空")
    @ApiModelProperty("出发城市名称")
    private String cityOutsetName;

    @NotNull(message = "到达城市id不能为空")
    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @NotBlank(message = "到达城市名称不能为空")
    @ApiModelProperty("到达城市名称")
    private String cityArriveName;

    @NotNull(message = "人数不能为空")
    @ApiModelProperty("人数")
    private Integer peopleMun;

    @NotNull(message = "飞机型号ID不能为空")
    @ApiModelProperty("飞机型号ID")
    private Long plainTypeId;

    @NotNull(message = "出发时间不能为空")
    @ApiModelProperty("出发时间")
    private Long outsetTime;

}
