package com.ym.im.handler;

import com.ym.im.entity.base.NettyConstant;
import com.ym.im.factory.SingleChatFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author: JJww
 * @Date:2019/11/14
 */
public abstract class BaseHandler<T> extends SimpleChannelInboundHandler<T> {

    @Autowired
    private SingleChatFactory singleChatFactory;

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        singleChatFactory.getService(ctx.channel().attr(NettyConstant.TYPE).get()).offline(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        singleChatFactory.getService(ctx.channel().attr(NettyConstant.TYPE).get()).offline(ctx);
    }

}
