package com.jumeirah.common.service.impl;

import com.jumeirah.common.entity.StrokeDiscount;
import com.jumeirah.common.mapper.StrokeDiscountMapper;
import com.jumeirah.common.service.StrokeDiscountService;
import com.jumeirah.common.param.StrokeDiscountPageParam;
import com.jumeirah.common.vo.StrokeDiscountQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 优惠行程表 服务实现类
 *
 * @author xxx
 * @since 2020-10-14
 */
@Slf4j
@Service
public class StrokeDiscountServiceImpl extends BaseServiceImpl<StrokeDiscountMapper, StrokeDiscount> implements StrokeDiscountService {

    @Autowired
    private StrokeDiscountMapper strokeDiscountMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveStrokeDiscount(StrokeDiscount strokeDiscount) throws Exception {
        return super.save(strokeDiscount);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateStrokeDiscount(StrokeDiscount strokeDiscount) throws Exception {
        return super.updateById(strokeDiscount);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteStrokeDiscount(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public StrokeDiscountQueryVo getStrokeDiscountById(Long id) throws Exception {
        return strokeDiscountMapper.getStrokeDiscountById(id);
    }

    @Override
    public Paging<StrokeDiscountQueryVo> getStrokeDiscountPageList(StrokeDiscountPageParam strokeDiscountPageParam) throws Exception {
        Page<StrokeDiscountQueryVo> page = new PageInfo<>(strokeDiscountPageParam, OrderItem.desc(getLambdaColumn(StrokeDiscount::getCreateTime)));
        IPage<StrokeDiscountQueryVo> iPage = strokeDiscountMapper.getStrokeDiscountPageList(page, strokeDiscountPageParam);
        return new Paging<StrokeDiscountQueryVo>(iPage);
    }

}
