package com.jumeirah.api.merchant.controller;

import com.jumeirah.common.param.MerchantUserPermissionQueryVo;
import com.jumeirah.common.service.MerchantUserPermissionService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商家用户权限关系 控制器
 *
 * @author giao
 * @since 2020-10-19
 */
@Slf4j
@RestController
@RequestMapping("/merchant/merchantUserPermission")
@Api(value = "商家用户权限关系API", tags = {"商家用户权限关系"})
public class MerchantUserPermissionController extends BaseController {

    @Autowired
    private MerchantUserPermissionService merchantUserPermissionService;


    /**
     *查询商家用户权限详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "商家用户权限关系详情", type = OperationLogType.INFO)
    @ApiOperation(value = "商家用户权限关系详情")
    public ApiResult<MerchantUserPermissionQueryVo> getMerchantUserPermission(@PathVariable("id") Long id) throws Exception {
        MerchantUserPermissionQueryVo merchantUserPermissionQueryVo = merchantUserPermissionService.getMerchantUserPermissionById(id);
        return ApiResult.ok(merchantUserPermissionQueryVo);
    }

//    /**
//     * 添加商家用户权限关系
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加商家用户权限关系", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加商家用户权限关系")
//    public ApiResult<Boolean> addMerchantUserPermission(@Validated(Add.class) @RequestBody MerchantUserPermission merchantUserPermission) throws Exception {
//        boolean flag = merchantUserPermissionService.saveMerchantUserPermission(merchantUserPermission);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改商家用户权限关系
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改商家用户权限关系", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改商家用户权限关系")
//    public ApiResult<Boolean> updateMerchantUserPermission(@Validated(Update.class) @RequestBody MerchantUserPermission merchantUserPermission) throws Exception {
//        boolean flag = merchantUserPermissionService.updateMerchantUserPermission(merchantUserPermission);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除商家用户权限关系
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除商家用户权限关系", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除商家用户权限关系")
//    public ApiResult<Boolean> deleteMerchantUserPermission(@PathVariable("id") Long id) throws Exception {
//        boolean flag = merchantUserPermissionService.deleteMerchantUserPermission(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取商家用户权限关系详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "商家用户权限关系详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "商家用户权限关系详情")
//    public ApiResult<MerchantUserPermissionQueryVo> getMerchantUserPermission(@PathVariable("id") Long id) throws Exception {
//        MerchantUserPermissionQueryVo merchantUserPermissionQueryVo = merchantUserPermissionService.getMerchantUserPermissionById(id);
//        return ApiResult.ok(merchantUserPermissionQueryVo);
//    }
//
//    /**
//     * 商家用户权限关系分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "商家用户权限关系分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "商家用户权限关系分页列表")
//    public ApiResult<Paging<MerchantUserPermissionQueryVo>> getMerchantUserPermissionPageList(@Validated @RequestBody MerchantUserPermissionPageParam merchantUserPermissionPageParam) throws Exception {
//        Paging<MerchantUserPermissionQueryVo> paging = merchantUserPermissionService.getMerchantUserPermissionPageList(merchantUserPermissionPageParam);
//        return ApiResult.ok(paging);
//    }

}

