package com.jumeirah.api.app.controller;

import com.jumeirah.common.param.StrokeDiscountPageParam;
import com.jumeirah.common.service.StrokeDiscountService;
import com.jumeirah.common.vo.StrokeDiscountQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 优惠行程表 控制器
 *
 * @author xxx
 * @since 2020-10-14
 */
@Slf4j
@RestController
@RequestMapping("/app/strokeDiscount")
@Api(value = "优惠行程表API", tags = {"优惠行程表"})
public class StrokeDiscountController extends BaseController {

    @Autowired
    private StrokeDiscountService strokeDiscountService;

    /**
     * 优惠行程表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "优惠行程表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "优惠行程表分页列表")
    public ApiResult<Paging<StrokeDiscountQueryVo>> getStrokeDiscountPageList(@Validated @RequestBody StrokeDiscountPageParam strokeDiscountPageParam) throws Exception {
        Paging<StrokeDiscountQueryVo> paging = strokeDiscountService.getStrokeDiscountPageList(strokeDiscountPageParam);
        return ApiResult.ok(paging);
    }

}

