package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.BusinessPlain;
import com.jumeirah.common.param.BusinessPlainPageParam;
import com.jumeirah.common.vo.BusinessPlainQueryForAppVo;
import com.jumeirah.common.vo.BusinessPlainQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 公务机出售/托管表 Mapper 接口
 *
 * @author giao
 * @since 2020-10-14
 */
@Repository
public interface BusinessPlainMapper extends BaseMapper<BusinessPlain> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    BusinessPlainQueryVo getBusinessPlainById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param businessPlainPageParam
     * @return
     */
    IPage<BusinessPlainQueryVo> getBusinessPlainPageList(@Param("page") Page page, @Param("param") BusinessPlainPageParam businessPlainPageParam);


    IPage<BusinessPlainQueryForAppVo> getBusinessPlainPageListForApp(@Param("page") Page page, @Param("param") BusinessPlainPageParam businessPlainPageParam);

}
