package com.jumeirah.common.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 行程类型，0-单程，1-往返行程，2-货运，3-医疗
 */
@Getter
@AllArgsConstructor
public enum StrokeTypeEnum implements BaseEnum {

    ONE_WAY(0, "单程"),
    ROUND_TRIP(1, "往返"),
    CARGO_FLIGHT(2, "货运"),
    MEDICAL_FLIGHT(3, "医疗"),
    PREFERENTIAL_TUNING(4, "优惠调机"),
    ;

    /**
     * 编号
     */
    private final Integer code;
    /**
     * 名称
     */
    private final String desc;

}
