package com.ym.im.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ym.im.entity.ChatRecord;
import com.ym.im.entity.MsgBody;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.nio.NioSocketChannel;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * @author 陈俊雄
 * @date 2019/5/29
 **/
public interface MsgBodyService {

    /**
     * 消息流程处理器
     *
     * @param ctx
     * @param msgBody
     * @throws JsonProcessingException
     */
    void msgBodyHandle(@NotNull ChannelHandlerContext ctx, @Valid MsgBody<ChatRecord> msgBody) throws JsonProcessingException;

    /**
     * 发送与回执
     *
     * @param channel
     * @param msgBody
     * @throws JsonProcessingException
     */
    void sendAndAck(NioSocketChannel channel, MsgBody<ChatRecord> msgBody) throws JsonProcessingException;
}
