package com.jumeirah.common.param.app;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * APP用户
 *
 * @author wei
 * @since 2020-09-23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AppUserInfoParam对象")
public class AppUserInfoParam extends BaseEntity {

    @ApiModelProperty("姓")
    private String surname;

    @ApiModelProperty("名")
    private String name;

    @ApiModelProperty("公司名")
    private String companyName;

    @ApiModelProperty("微信号")
    private String wechat;

    @ApiModelProperty("出生日期")
    private String dateOfBirth;

//    @ApiModelProperty("昵称")
//    private String nickname;

    @ApiModelProperty("性别，0：女，1：男，默认1")
    private Integer gender;

    @ApiModelProperty("头像")
    private String head;

}
