package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jumeirah.common.entity.CharterIntroduction;
import com.jumeirah.common.mapper.CharterIntroductionMapper;
import com.jumeirah.common.param.CharterIntroductionAddParam;
import com.jumeirah.common.param.CharterIntroductionPageParam;
import com.jumeirah.common.param.CharterIntroductionUpdateParam;
import com.jumeirah.common.service.CharterIntroductionService;
import com.jumeirah.common.vo.CharterIntroductionImgForAppVo;
import com.jumeirah.common.vo.CharterIntroductionQueryForAppVo;
import com.jumeirah.common.vo.CharterIntroductionQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.geekidea.springbootplus.framework.util.Jackson;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 包机介绍 服务实现类
 *
 * @author giao
 * @since 2020-10-14
 */
@Slf4j
@Service
public class CharterIntroductionServiceImpl extends BaseServiceImpl<CharterIntroductionMapper, CharterIntroduction> implements CharterIntroductionService {

    @Autowired
    private CharterIntroductionMapper charterIntroductionMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveCharterIntroduction(CharterIntroductionAddParam charterIntroductionAddParam) throws Exception {
        CharterIntroduction charterIntroduction = new CharterIntroduction();
        BeanUtils.copyProperties(charterIntroductionAddParam, charterIntroduction);
        // 图片列表转json
        charterIntroduction.setImgUrl(Jackson.toJsonString(charterIntroductionAddParam.getImgList()));
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        charterIntroduction.setMcId(jwtToken.getMcId());
        return super.save(charterIntroduction);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateCharterIntroduction(CharterIntroductionUpdateParam charterIntroductionUpdateParam) throws Exception {

        CharterIntroduction charterIntroduction = new CharterIntroduction();
        BeanUtils.copyProperties(charterIntroductionUpdateParam, charterIntroduction);
        if (charterIntroductionUpdateParam.getImgUrl() != null) {
            charterIntroduction.setImgUrl(Jackson.toJsonString(charterIntroductionUpdateParam.getImgUrl()));
        }
        return super.updateById(charterIntroduction);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteCharterIntroduction(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public CharterIntroductionQueryVo getCharterIntroductionById(Long id) throws Exception {
        return charterIntroductionMapper.getCharterIntroductionById(id);
    }

    @Override
    public Paging<CharterIntroductionQueryVo> getCharterIntroductionPageList(CharterIntroductionPageParam charterIntroductionPageParam) throws Exception {
        Page<CharterIntroductionQueryVo> page = new PageInfo<>(charterIntroductionPageParam, OrderItem.desc(getLambdaColumn(CharterIntroduction::getCreateTime)));
        IPage<CharterIntroductionQueryVo> iPage = charterIntroductionMapper.getCharterIntroductionPageList(page, charterIntroductionPageParam);
        return new Paging<CharterIntroductionQueryVo>(iPage);
    }

    @Override
    public Paging<CharterIntroductionQueryForAppVo> getCharterIntroductionForAppPageList(CharterIntroductionPageParam charterIntroductionPageParam) throws Exception {
        Page<CharterIntroductionQueryForAppVo> page = new PageInfo<>(charterIntroductionPageParam, OrderItem.desc("ci.create_time"));
        IPage<CharterIntroductionQueryForAppVo> iPage = charterIntroductionMapper.getCharterIntroductionForAppPageList(page, charterIntroductionPageParam);

        // 处理过的数据列表
        List<CharterIntroductionQueryForAppVo> newRecords = new ArrayList<CharterIntroductionQueryForAppVo>();

        // 对数据做二次处理
        for (CharterIntroductionQueryForAppVo charterIntroductionQueryForAppVo : iPage.getRecords()) {
            ObjectMapper objectMapper = new ObjectMapper();
            JavaType javaType = objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, CharterIntroductionImgForAppVo.class);
            // 处理图片url, 因为数据库存的json 需要转换
            List<CharterIntroductionImgForAppVo> lst = (List<CharterIntroductionImgForAppVo>) objectMapper.readValue(charterIntroductionQueryForAppVo.getImgUrl(), javaType);
            charterIntroductionQueryForAppVo.setImgList(lst);
            charterIntroductionQueryForAppVo.setImgUrl(null);
            newRecords.add(charterIntroductionQueryForAppVo);
        }
        iPage.setRecords(newRecords);

        return new Paging<>(iPage);
    }

}
