package com.jumeirah.common.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 审核状态,0审核中,1审核通过,2审核未通过
 */
@Getter
@AllArgsConstructor
public enum StrokeAuditStatusEnum implements BaseEnum {

    UNDER_REVIEW(0, "审核中"),
    AUDIT_OK(1, "审核通过"),
    AUDIT_FAILED(2, "审核未通过"),
    ;

    /**
     * 编号
     */
    private final Integer code;
    /**
     * 名称
     */
    private final String desc;


}
