package com.jumeirah.common.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 状态，0-审核中，1-进行中，2-已完成，99-取消
 */
@Getter
@AllArgsConstructor
public enum PlainTypeStatusEnum implements BaseEnum {

    OK(0, "正常"),
    DISABLE(1, "禁用"),
    CANCEL(99, "删除");

    /**
     * 编号
     */
    private final Integer code;
    /**
     * 名称
     */
    private final String desc;


}
