package com.ym.im.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ym.im.entity.MsgBody;
import com.ym.im.entity.Session;
import com.ym.im.entity.enums.ResultStatus;
import com.ym.im.entity.model.SessionInfo;
import com.ym.im.service.SessionListService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author: JJww
 * @Date:2020-10-21
 */
@RestController
@RequestMapping("/session")
@Api(description = "会话列表相关")
public class SessionController {

    @Autowired
    private SessionListService sessionListService;


    @GetMapping("/list")
    @ApiOperation(value = "获取用户会话列表")
    public MsgBody<List<SessionInfo>> getSessionList(Long userId) {
        return sessionListService.getSessionList(userId);
    }

    @DeleteMapping("/list")
    @ApiOperation(value = "删除商户会话")
    public MsgBody deleteSessionList(Long userId, Long merchantId) {
        sessionListService.remove(new QueryWrapper<Session>().lambda().eq(Session::getUserId, userId).eq(Session::getMerchantId, merchantId));
        return new MsgBody<>().setCode(ResultStatus.SUCCESS.getCode());
    }


}
