package com.jumeirah.common.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.geekidea.springbootplus.framework.core.validator.groups.Update;

/**
 * APP用户
 *
 * @author wei
 * @since 2020-09-23
 */
@Data
@Accessors(chain = true)
    @EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AppUser对象")
public class AppUser extends BaseEntity {
private static final long serialVersionUID=1L;

            @NotNull(message = "id不能为空", groups = {Update.class})
        @ApiModelProperty("主键")
                @TableId(value = "id", type = IdType.AUTO)
                private Long id;

            @ApiModelProperty("用户名")
        private String username;

            @ApiModelProperty("昵称")
        private String nickname;

            @NotBlank(message = "密码不能为空")
        @ApiModelProperty("密码")
        private String password;

            @ApiModelProperty("盐值")
        private String salt;

            @ApiModelProperty("手机号码")
        private String phone;

            @ApiModelProperty("手机区号")
        private String phoneArea;

            @ApiModelProperty("性别，0：女，1：男，默认1")
        private Integer gender;

            @ApiModelProperty("头像")
        private String head;

            @ApiModelProperty("备注")
        private String remark;

            @ApiModelProperty("状态，0：禁用，1：启用，2：锁定")
        private Integer state;

            @ApiModelProperty("部门id")
        private Long departmentId;

            @ApiModelProperty("角色id")
        private Long roleId;

            @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
            @TableLogic
private Integer deleted;

            @ApiModelProperty("版本")
        @Version
    private Integer version;

            @ApiModelProperty("创建时间")
        private Date createTime;

            @ApiModelProperty("修改时间")
        private Date updateTime;

}
