# 卓美亚航空 - 后端项目

## 框架介绍
> 本项目使用第三方开源脚手架项目: spring-boot-plus 参考:README-zh.md

---
## 项目结构
```text
    └── spring-boot-plus
    ├── admin               SpringBootAdmin Server服务监控模块
    ├── bootstrap           spring-boot-plus 启动模块
    ├── config              配置模块
    ├── distribution        打包模块
    ├── docs                文档目录
    ├── framework           框架核心模块
    ├── generator           代码生成模块
    ├── scheduled           任务调度模块
    └── api-system          平台管理系统api模块
    └── api-app             app的api模块
    └── api-merchant        商家api服务模块
    └── common              通用模块(包含service dao mapper)
```
---
## 安装中间件
redis(必须本地开启)

mysql5.7 (你本地可以不开,在本地配置中已经连上了测试环境)





## 开发规范
---
### 关于模块
api-system    api-app   api-merchant 

三个模块是各自针对不同后端模块的api接口,都包含common模块的依赖,

你只能在其中开发模块属于自己的controller和service,

并且可以实现当前模块的service业务逻辑层,但对数据库操作,请一定调用common模块的service,不要在api-XXX的模块下写数据库的操作. 

如果业务流程没有很复杂, 在controller类中你可以直接调用common模块的service

### 例如:
#### 商户注册
在api-merchant模块中的controller包下新建一个Register控制器,

模块下每个控制器url路径必须要加上前缀```"/merchant/"```,这样为了方便权限控制

像这样:
```
@RequestMapping("/merchant/register/")
```

注册业务逻辑要调用common模块中的service去操作


#### app注册
在api-app模块中的controller包下新建一个Register控制器,

模块下每个控制器url路径必须要加上前缀```"/app/"```,这样为了方便权限控制

像这样:
```
@RequestMapping("/app/register/")
```

注册业务逻辑要调用common模块中的service去操作

---
## swagger文档
http://127.0.0.1:8889/api/doc.html#/home

左上角可以切换到不同的模块

---

## 配置接口权限
*例如:*
```


/**
* 获取获取菜单树形列表
*
* @return
*/
@PostMapping("/getAllMenuTree")
@RequiresPermissions("sys:permission:all:menu:tree")
public ApiResult<List<SysPermissionTreeVo>> getAllMenuTree() throws Exception {
    List<SysPermissionTreeVo> treeVos = sysPermissionService.getAllMenuTree();
    return ApiResult.ok(treeVos);
}
```

>其中注解@RequiresPermissions表示访问此接口需要的权限, 
权限可以在数据库表中先分配给角色, 再将角色与用户进行关联

**系统平台权限相关表:**

系统角色sys_role,

系统用户sys_user,

系统权限sys_permission,

角色权限关系sys_role_permission

---
## shiro理论知识

Subject(主体)： 用于记录当前的操作用户，Subject在shiro中是一个接口，接口中定义了很多认证授相关的方法，外部程序通过subject进行认证授权，而subject是通过SecurityManager安全管理器进行认证授权

SecurityManager(安全管理器)：对Subject 进行管理，他是shiro的核心SecurityManager是一个接口，继承了Authenticator, Authorizer, SessionManager这三个接口。

Authenticator(认证器)：对用户身份进行认证

Authorizer(授权器)：用户通过认证后，来判断时候拥有该权限

realm：获取用户权限数据

sessionManager(会话管理)：shiro框架定义了一套会话管理，它不依赖web容器的session，所以shiro可以使用在非web应用上，也可以将分布式应用的会话集中在一点管理，此特性可使它实现单点登录。

CacheManager(缓存管理器)：将用户权限数据存储在缓存，这样可以提高性能。

authc:所有url都必须认证通过才可以访问; 

anon:所有url都都可以匿名访问;

过滤链定义，从上向下顺序执行，一般将/**放在最为下边