package com.sien.common.service;

import com.sien.common.entity.VipPrice;
import com.sien.common.param.VipPricePageParam;
import com.sien.common.vo.app.VipPriceQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 会员价格表 服务类
 *
 * @author xxx
 * @since 2021-03-11
 */
public interface VipPriceService extends BaseService<VipPrice> {

        /**
         * 保存
         *
         * @param vipPrice
         * @return
         * @throws Exception
         */
        boolean saveVipPrice(VipPrice vipPrice) throws Exception;

        /**
         * 修改
         *
         * @param vipPrice
         * @return
         * @throws Exception
         */
        boolean updateVipPrice(VipPrice vipPrice) throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteVipPrice(Long id) throws Exception;

        /**
         * 根据ID获取查询对象
         *
         * @param id
         * @return
         * @throws Exception
         */
        VipPriceQueryVo getVipPriceById(Long id) throws Exception;

        /**
         * 获取分页对象
         *
         * @param vipPricePageParam
         * @return
         * @throws Exception
         */
        Paging<VipPriceQueryVo> getVipPricePageList(VipPricePageParam vipPricePageParam) throws Exception;

}
