package com.sien.common.controller;

import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.sien.common.param.DonationRecordPageParam;
import com.sien.common.param.app.DonationRecordAdd;
import com.sien.common.service.DonationRecordService;
import com.sien.common.vo.DonationRecordQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 捐款记录 控制器
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@RestController
@RequestMapping("/donationRecord")
@Api(value = "捐款记录API", tags = {"捐款记录"})
public class DonationRecordController extends BaseController {

    @Autowired
    private DonationRecordService donationRecordService;

    /**
     * 添加捐款记录
     */
    @PostMapping("/add")
    @OperationLog(name = "我要捐款", type = OperationLogType.ADD)
    @ApiOperation(value = "我要捐款")
    public ApiResult<WxPayMpOrderResult> addDonationRecord(@Validated(Add.class) @RequestBody DonationRecordAdd donationRecordAdd) throws Exception {

        return donationRecordService.add(donationRecordAdd);
    }


    /**
     * 我的捐款记录分页列表
     */
//    @PostMapping("/getMyPageList")
//    @OperationLog(name = "我的捐款记录分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "我的捐款记录分页列表")
//    public ApiResult<List<DonationRecord>> getDonationRecordPageList() throws Exception {
//        return donationRecordService.getDonationRecordAllList();
//    }

    /**
     * 我的捐款记录分页列表
     */
    @PostMapping("/getMyPageList")
    @OperationLog(name = "我的捐款记录分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "我的捐款记录分页列表")
    public ApiResult<Paging<DonationRecordQueryVo>> getDonationRecordPageList(@Validated @RequestBody DonationRecordPageParam donationRecordPageParam) throws Exception {
        Paging<DonationRecordQueryVo> paging = donationRecordService.getDonationRecordPageList(donationRecordPageParam);
        return ApiResult.ok(paging);
    }


//        /**
//     * 获取捐款记录详情
//     */
//    @GetMapping("/info/{id}")
//        @OperationLog(name = "捐款记录详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "捐款记录详情")
//    public ApiResult<DonationRecordQueryVo> getDonationRecord(@PathVariable("id") Long id)throws Exception{
//            DonationRecordQueryVo donationRecordQueryVo = donationRecordService.getDonationRecordById(id);
//            return ApiResult.ok(donationRecordQueryVo);
//            }


//    /**
//     * 修改捐款记录
//     */
//    @PostMapping("/update")
//        @OperationLog(name = "修改捐款记录", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改捐款记录")
//    public ApiResult<Boolean> updateDonationRecord(@Validated(Update.class) @RequestBody DonationRecord donationRecord)throws Exception{
//            boolean flag= donationRecordService.updateDonationRecord(donationRecord);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 删除捐款记录
//     */
//    @PostMapping("/delete/{id}")
//        @OperationLog(name = "删除捐款记录", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除捐款记录")
//    public ApiResult<Boolean> deleteDonationRecord(@PathVariable("id") Long id)throws Exception{
//            boolean flag= donationRecordService.deleteDonationRecord(id);
//            return ApiResult.result(flag);
//            }


}

