package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.ContactStaff;
import com.jumeirah.common.mapper.ContactStaffMapper;
import com.jumeirah.common.param.ContactStaffPageParam;
import com.jumeirah.common.param.ContactStaffQueryVo;
import com.jumeirah.common.service.ContactStaffService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 服务实现类
 *
 * @author xxx
 * @since 2020-10-27
 */
@Slf4j
@Service
public class ContactStaffServiceImpl extends BaseServiceImpl<ContactStaffMapper, ContactStaff> implements ContactStaffService {

    @Autowired
    private ContactStaffMapper contactStaffMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveContactStaff(ContactStaff contactStaff) throws Exception {
        return super.save(contactStaff);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateContactStaff(ContactStaff contactStaff) throws Exception {
        return super.updateById(contactStaff);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteContactStaff(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public ContactStaffQueryVo getContactStaffById(Long id) throws Exception {
        return contactStaffMapper.getContactStaffById(id);
    }

    @Override
    public Paging<ContactStaffQueryVo> getContactStaffPageList(ContactStaffPageParam contactStaffPageParam) throws Exception {
        Page<ContactStaffQueryVo> page = new PageInfo<>(contactStaffPageParam, OrderItem.desc(getLambdaColumn(ContactStaff::getCreateTime)));
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        IPage<ContactStaffQueryVo> iPage = contactStaffMapper.getContactStaffPageList(page, contactStaffPageParam,jwtToken.getMcId());
        return new Paging<ContactStaffQueryVo>(iPage);
    }

}
