package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.Merchant;
import com.jumeirah.common.param.MerchantPageParam;
import com.jumeirah.common.vo.MerchantQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 航空公司商家表 Mapper 接口
 *
 * @author giao
 * @since 2020-10-13
 */
@Repository
public interface MerchantMapper extends BaseMapper<Merchant> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    MerchantQueryVo getMerchantById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param merchantPageParam
     * @return
     */
    IPage<MerchantQueryVo> getMerchantPageList(@Param("page") Page page, @Param("param") MerchantPageParam merchantPageParam);

}
