package com.jumeirah.api.merchant.controller.order;


import com.jumeirah.common.entity.PlainType;
import com.jumeirah.common.service.PlainTypeService;
import com.jumeirah.common.vo.PlainTypeQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 飞机型号表 控制器
 *
 * @author wei
 * @since 2020-10-09
 */
@Slf4j
@RestController
@RequestMapping("/merchant/plainType")
@Module("${cfg.module}")
@Api(value = "飞机型号表API", tags = {"飞机型号"})
public class McPlainTypeController extends BaseController {

    @Autowired
    private PlainTypeService plainTypeService;

    /**
     * 获取飞机型号列表
     */
    @GetMapping("/getAllList")
    @OperationLog(name = "获取飞机型号列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "获取飞机型号列表", response = PlainTypeQueryVo.class)
    @RequiresPermissions("merchant:aircraft:management:view")
    public ApiResult<List<PlainType> > getAllList() throws Exception {
       List<PlainType> plainTypeList = plainTypeService.getAllMap();
        return ApiResult.ok(plainTypeList);
    }

}

