package com.jumeirah.api.merchant.controller;

import com.jumeirah.api.merchant.entity.param.McAppUserParam;
import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.service.AppUserService;
import com.jumeirah.common.vo.AppUserQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * APP用户 控制器
 *
 * @author wei
 * @since 2020-09-23
 */
@Slf4j
@RestController
@Module("api-app")
@Api(value = "app用户API", tags = {"APP用户相关"})
@RequestMapping("/merchant/appUser/")
public class McAppUserController extends BaseController {

    @Autowired
    private AppUserService appUserService;

    /**
     * APP用户分页列表
     */
    @PostMapping("/getList")
    @OperationLog(name = "APP用户分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "APP用户分页列表", response = AppUserQueryVo.class)
    public ApiResult<List<AppUser>>  getAppUserPageList(@Validated @RequestBody McAppUserParam mcAppUserParam) throws Exception {
        List<AppUser> appUsers = appUserService.listByIds(mcAppUserParam.getIds());
        return ApiResult.ok(appUsers);
    }


}

