package com.jumeirah.common.controller;

import com.jumeirah.common.entity.ContactStaff;
import com.jumeirah.common.param.ContactStaffPageParam;
import com.jumeirah.common.param.ContactStaffQueryVo;
import com.jumeirah.common.service.ContactStaffService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 控制器
 *
 * @author xxx
 * @since 2020-10-27
 */
/*@Slf4j
@RestController
@RequestMapping("/contactStaff")
@Api(value = "API", tags = {""})*/
public class ContactStaffController extends BaseController {

    @Autowired
    private ContactStaffService contactStaffService;

    /**
     * 添加
     */
    @PostMapping("/add")
    @OperationLog(name = "添加", type = OperationLogType.ADD)
    @ApiOperation(value = "添加")
    public ApiResult<Boolean> addContactStaff(@Validated(Add.class) @RequestBody ContactStaff contactStaff) throws Exception {
        boolean flag = contactStaffService.saveContactStaff(contactStaff);
        return ApiResult.result(flag);
    }

    /**
     * 修改
     */
    @PostMapping("/update")
    @OperationLog(name = "修改", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改")
    public ApiResult<Boolean> updateContactStaff(@Validated(Update.class) @RequestBody ContactStaff contactStaff) throws Exception {
        boolean flag = contactStaffService.updateContactStaff(contactStaff);
        return ApiResult.result(flag);
    }

    /**
     * 删除
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除")
    public ApiResult<Boolean> deleteContactStaff(@PathVariable("id") Long id) throws Exception {
        boolean flag = contactStaffService.deleteContactStaff(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "详情", type = OperationLogType.INFO)
    @ApiOperation(value = "详情")
    public ApiResult<ContactStaffQueryVo> getContactStaff(@PathVariable("id") Long id) throws Exception {
        ContactStaffQueryVo contactStaffQueryVo = contactStaffService.getContactStaffById(id);
        return ApiResult.ok(contactStaffQueryVo);
    }

    /**
     * 分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "分页列表")
    public ApiResult<Paging<ContactStaffQueryVo>> getContactStaffPageList(@Validated @RequestBody ContactStaffPageParam contactStaffPageParam) throws Exception {
        Paging<ContactStaffQueryVo> paging = contactStaffService.getContactStaffPageList(contactStaffPageParam);
        return ApiResult.ok(paging);
    }

}

