
package com.jumeirah.api.app.controller;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * Hello World Controller
 *
 **/
@Slf4j
@Api(value = "Hello World2", tags = {"APP Hello World2"})
@RestController
@RequestMapping("/app")
public class AppHelloWorldController {

    /**
     * Hello World
     *
     * @return
     * @throws IOException
     */
    @GetMapping(value = "/world")
    @OperationLog(name = "helloWorld")
    @ApiOperation(value = "Hello World", response = String.class)
    public ApiResult<String> helloWorld() throws IOException {
        log.debug("Hello World...app");
        return ApiResult.ok("Hello World app");
    }

}
