package com.ym.im.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ym.im.entity.MsgBody;
import com.ym.im.entity.Session;
import com.ym.im.entity.enums.ResultStatus;
import com.ym.im.service.SessionListService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author: JJww
 * @Date:2020-10-21
 */
@RestController
@RequestMapping("/session")
@Api(description = "会话列表相关")
public class SessionController {

    @Autowired
    private SessionListService sessionListService;

    @GetMapping("/list")
    @ApiOperation(value = "获取用户会话列表")
    public MsgBody<List<Session>> getSessionList(Long userId) {
        return new MsgBody<List<Session>>()
                .setStatus(ResultStatus.SUCCESS.getCode())
                .setData(sessionListService.list(new QueryWrapper<Session>().lambda().eq(Session::getUserId, userId)));

    }

    @DeleteMapping("/list")
    @ApiOperation(value = "删除商户会话")
    public MsgBody deleteSessionList(Long merchantId) {
        sessionListService.remove(new QueryWrapper<Session>().lambda().eq(Session::getMerchantId, merchantId));
        return new MsgBody<>().setStatus(ResultStatus.SUCCESS.getCode());
    }

}
