package com.jumeirah.api.merchant.controller;

import com.jumeirah.common.entity.MerchantUser;
import com.jumeirah.common.param.LoginParam;
import com.jumeirah.common.param.MerchantUserPageParam;
import com.jumeirah.common.service.MerchantUserService;
import com.jumeirah.common.vo.LoginSysUserTokenVo;
import com.jumeirah.common.vo.MerchantUserQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.annotation.OperationLogIgnore;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 商家 控制器
 *
 * @author wei
 * @since 2020-09-27
 */
@Slf4j
@RestController
@RequestMapping("/merchantUser")
@Module("${cfg.module}")
@Api(value = "商家API", tags = {"商家"})
public class MerchantUserController extends BaseController {

    @Autowired
    private MerchantUserService merchantUserService;

    /**
     * 添加商家
     */
    @PostMapping("/add")
    @OperationLog(name = "添加商家", type = OperationLogType.ADD)
    @ApiOperation(value = "添加商家", response = ApiResult.class)
    public ApiResult<Boolean> addMerchantUser(@Validated(Add.class) @RequestBody MerchantUser merchantUser) throws Exception {
        boolean flag = merchantUserService.saveMerchantUser(merchantUser);
        return ApiResult.result(flag);
    }

    /**
     * 修改商家
     */
    @PostMapping("/update")
    @OperationLog(name = "修改商家", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改商家", response = ApiResult.class)
    public ApiResult<Boolean> updateMerchantUser(@Validated(Update.class) @RequestBody MerchantUser merchantUser) throws Exception {
        boolean flag = merchantUserService.updateMerchantUser(merchantUser);
        return ApiResult.result(flag);
    }

    /**
     * 删除商家
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除商家", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除商家", response = ApiResult.class)
    public ApiResult<Boolean> deleteMerchantUser(@PathVariable("id") Long id) throws Exception {
        boolean flag = merchantUserService.deleteMerchantUser(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取商家详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "商家详情", type = OperationLogType.INFO)
    @ApiOperation(value = "商家详情", response = MerchantUserQueryVo.class)
    public ApiResult<MerchantUserQueryVo> getMerchantUser(@PathVariable("id") Long id) throws Exception {
        MerchantUserQueryVo merchantUserQueryVo = merchantUserService.getMerchantUserById(id);
        return ApiResult.ok(merchantUserQueryVo);
    }

    /**
     * 商家分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "商家分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "商家分页列表", response = MerchantUserQueryVo.class)
    public ApiResult<Paging<MerchantUserQueryVo>> getMerchantUserPageList(@Validated @RequestBody MerchantUserPageParam merchantUserPageParam) throws Exception {
        Paging<MerchantUserQueryVo> paging = merchantUserService.getMerchantUserPageList(merchantUserPageParam);
        return ApiResult.ok(paging);
    }

    @PostMapping("/login")
    @OperationLogIgnore
    @ApiOperation(value = "登录", notes = "商家登录", response = LoginSysUserTokenVo.class)
    public ApiResult<LoginSysUserTokenVo> login(@Validated @RequestBody LoginParam loginParam, HttpServletResponse response, @RequestHeader(required = false) String language) throws Exception {
        return merchantUserService.login(loginParam, response, language);
    }

}

