package com.jumeirah.api.app.entity.vo;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.sql.Timestamp;

/**
 * 行程表
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "添加医疗行程入参对象")
public class StrokeAddMedicalTreatmentVo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "出发城市id不能为空")
    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @NotNull(message = "到达城市id不能为空")
    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @NotNull(message = "出发时间不能为空")
    @ApiModelProperty("出发时间")
    private Timestamp outsetTime;

    @NotBlank(message = "到达城市名称不能为空")
    @ApiModelProperty("病人疾病名称")
    private String diseaseName;

    @NotBlank(message = "病人病情诊断书不能为空")
    @ApiModelProperty("病人病情诊断书")
    private String medicalCertificateUrl;

    @ApiModelProperty("配备器械（格式：1,2,3）逗号分隔")
    private String instruments;

    @ApiModelProperty("医护人员，0-医生，1-护士，2-护工（格式：0,1,2）逗号分隔")
    private String medicalPersons;

    @ApiModelProperty("备注")
    private String remarks;

}
