package com.jumeirah.common.service;

import com.jumeirah.common.entity.SysNotice;
import com.jumeirah.common.param.SysNoticePageParam;
import com.jumeirah.common.param.SysNoticeQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 系统通知表 服务类
 *
 * @author xxx
 * @since 2020-11-06
 */
public interface SysNoticeService extends BaseService<SysNotice> {

        /**
         * 保存
         *
         * @param sysNotice
         * @return
         * @throws Exception
         */
        boolean saveSysNotice(SysNotice sysNotice) throws Exception;

        /**
         * 修改
         *
         * @param sysNotice
         * @return
         * @throws Exception
         */
        boolean updateSysNotice(SysNotice sysNotice) throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteSysNotice(Long id) throws Exception;

        /**
         * 根据ID获取查询对象
         *
         * @param id
         * @return
         * @throws Exception
         */
        SysNoticeQueryVo getSysNoticeById(Long id) throws Exception;

        /**
         * 获取分页对象
         *
         * @param sysNoticePageParam
         * @return
         * @throws Exception
         */
        Paging<SysNoticeQueryVo> getSysNoticePageList(SysNoticePageParam sysNoticePageParam) throws Exception;

}
